//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.6 Page 134
//Title: Temperature and mass of the gas
//===================================================

model Ex5_6

//============
//Parameter Section
parameter Real M(unit = "kg/kmol") = 29 "Molecular weight of an ideal gas";
parameter Real gamma(unit = "-") = 1.4 "Ratio of specific heats";
parameter Real V(unit = "m^3") = 1 "Volume of the tank";
parameter Real P1(unit = "MPa") = 10 "Initial pressure in the tank";
parameter Real T1(unit = "K") = 400 "Initial temperature in the tank";
parameter Real P2(unit = "MPa") = 5 "Final pressure in the tank";
parameter Real P(unit = "kPa") = 101.325 "Atmospheric pressure";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";


//===========
//Variabe section
Real T2(unit = "K") "Final temperature in  the tank";
Real m1(unit = "kg") "Initial mass of gas in the tank";
Real m2(unit = "kg") "Final mass of gas in the tank";
Real me(unit = "kg") "Mass of gas discharged";

//==========
//Equation Section
equation
(P2*10^3)-(P1*10^3)+((P1*10^3/T1)-(P2*10^3/T2))*gamma*((T1+T2)/2) = 0;    //Reduced energy equation pg no. 135
m1 = (P1*10^3*V)/(R*T1);
m2 = (P2*10^3*V)/(R*T2);
me = (m1-m2)*M;

end Ex5_6;

//===================================================
