//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.1 Page 212
//Title: Change in entropy
//===================================================

model Ex6_1

//============
//Parameter Section
parameter Real T1(unit = "K") = 300 "Temperature of the liquid";
parameter Real P1(unit = "bar") = 1 "Pressure of the liquid";
parameter Real v(unit = "m^3/kmol") = 0.1 "Molar volume of liquid";
parameter Real beta(unit = "K^-1") = 1.25/10^3 "Coefficient of volumetric expansion";
parameter Real P2(unit = "bar") = 20 "Final pressure of the liquid";

//==========
//Variable Section
Real V_T(unit = "m^3/kmol K") "Ratio";
Real delta_S(unit = "J/kmol K") "Change in entropy";

//==========
//Equation Section
equation
V_T = beta*v;
delta_S = -(V_T*(P2-P1)*10^5);

end Ex6_1;

//===================================================
