//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.11 Page 227
//Title: Specific heat at constant volume
//===================================================

model Ex6_11

//============
//Parameter Section
parameter Real T(unit = "K") = 273 "Temperature of mercury";
parameter Real P(unit = "bar") = 1 "Pressure of mercury";
parameter Real kappa(unit = "bar^-1") = 3.9/10^6 "Coefficient of compressibility";
parameter Real beta(unit = "K^-1") = 1.8/10^4 "Coefficient of volume expansion";
parameter Real Cp(unit = "kJ/kg K") = 0.14 "Specific heat of mercury at const. pressure";
parameter Real rho(unit = "kg/m^3") = 13.596*10^3 "Density of mercury";

//===========
//Variable Section
Real Cv(unit = "J/kg K") "Specific heat of mercury at const. volume";

//===========
//Equation Section
equation
(Cp*10^3)-Cv = ((beta^2*T)/(rho*kappa)*10^5);   //Using Eqn. 6.55 Ref. pg no. 227

end Ex6_11;

//===================================================
