//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.2 Page 214
//Title: Vapour pressure of water
//===================================================

model Ex6_2

//===========
//Parameter Section
parameter Real T1(unit = "K") = 363 "Temperature";
parameter Real T2(unit = "K") = 373 "Boiling point of water";
parameter Real P2s(unit = "kPa") = 101.3 "Vapour pressure of water at 373 K";
parameter Real delta_H(unit = "kJ/kg") = 2275 "Heat of vapourisation";
parameter Real R(unit = "kJ/kmol K") = 8.314 "Universal gas constant";
parameter Real M(unit = "kg/kmol") = 18 "Molecular weight of water";

//===========
//Variable Section
Real P1s(unit = "kPa") "Vapour pressure of water at 363 K";

//===========
//Equation Section
equation
log(P2s/P1s) = ((delta_H*M)/R)*((1/T1)-(1/T2));   //Clausius-Clapeyron equation

end Ex6_2;

//===================================================
