//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.23 Page 250
//Title: Fugacity of gas
//===================================================

model Ex6_23

//===========
//Parameter Section
parameter Real T(unit = "K") = 300 "Temperature of gas";
parameter Real P(unit = "bar") = 50 "Pressure of gas";
parameter Real A(unit = "m^3/mol") = -556.61 "Integral value from graph";
parameter Real R(unit = "J/mol K") = 8.314 "Universsal gas constant";

//===========
//Variable Section
Real f(unit = "bar") "Fugacity of gas";

//===========
//Equation Section
equation
log(f/P) = (A/(R*T));   //Using Eqn. 6.130 pg no. 249

end Ex6_23;

//===================================================
