//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.30 Page 255
//Title: Fugacity of n-butane
//===================================================

model Ex6_30

//============
//Parameter Section
parameter Real T(unit = "K") = 350 "Temperature of n-butane";
parameter Real P(unit = "bar") = 60 "Pressure of n-butane";
parameter Real Ps(unit = "bar") = 9.35 "Saturation pressure at 350 K";
parameter Real V(unit = "m^3/mol") = 0.1072/10^3 "Specific volume of n-butane at 350 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real phi(unit = "-")  = 0.834 "Fugacity coeffiient for sat. vapour at 350 K";

//============
//Variable Section
Real f_sat(unit = "bar") "Fugacity of sat. liquid at 350 K";
Real f(unit = "bar") "Fugacity of n-butane";

//============
//Equation Section
equation
f_sat = phi*Ps;
log(f/(f_sat)) = (V/(R*T))*(P-Ps)*10^5;

end Ex6_30;

//===================================================

