//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.31 Page 256
//Title: Activity of solid magnesium
//===================================================

model Ex6_31

//============
//Parameter Section
parameter Real T(unit = "K") = 300 "Temperature of solid magnesium";
parameter Real P(unit = "bar") = 10 "Pressure of solid magnesium";
parameter Real Po(unit = "bar") = 1 "Reference pressure";
parameter Real rho(unit = "kg/m^3") = 1.745*10^3 "Density of magnesium at 300 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real M(unit = "g/mol")  = 24.32 "Molecular weight of magnesium";

//============
//Variable Section
Real a(unit = "-") "Activity of solid magnesium";

//============
//Equation Section
equation
log(a) = ((M/(rho*10^3))/(R*T))*(P-Po)*10^5;   //Using Eqn. 6.149 pg no. 256

end Ex6_31;

//===================================================
