//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.13 Page 301
//Title: Fugacity, Fugacity coefficient,Activity,and Activity coefficient
//===================================================

package Ex7_13

model Ex7_13_a

//============
//Parameter Section
parameter Real T(unit = "K") = 298 "Temperature of liquid mixture";
parameter Real P(unit = "bar") = 20 "Pressure of liquid mixture";

//============
//Variable Section
Real x1(unit = "-") "Mole fraction of component 1";
Real f1(unit = "bar") "Fugacity of component 1";

//============
//Equation Section
equation
x1 = 1;     //Pure component
f1 = (50*x1)-(80*x1^2)+(40*x1^3);

end Ex7_13_a;

//============

model Ex7_13_b

extends Ex7_13_a;

//============
//Variable Section
Real phi1(unit = "-") "Fugacity coefficient of component 1";

//============
//Equation Section
equation
phi1 = f1/P;    //Fugacity coefficient

end Ex7_13_b;

//============

model Ex7_13_c


//============
//Variable Section
Real x1(unit = "-") "Mole fraction of component 1";
Real K1(unit = "bar") "Henry's law coefficient";

//============
//Equation Section
equation
x1 = 0;   //limit x1 tends to 0
K1 = 50-(80*x1)+(40*x1^2);    //Differentiated expression

end Ex7_13_c;

//============

end Ex7_13;
