//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.2 Page 277
//Title: Partial molar properties and properties of solutions
//===================================================

model Ex7_2

//============
//Parameter Section
parameter Real Vt(unit = "m^3") = 0.1 "Volume of solution";
parameter Real V1(unit = "m^3") = 0.03 "Volume of alcohol";
parameter Real V2(unit = "m^3") = 0.07 "Volume of water";
parameter Real rho1(unit = "kg/m^3") = 789 "Density of ethanol";
parameter Real rho2(unit = "kg/m^3") = 997 "Density of water";
parameter Real V_1(unit = "m^3/mol") = 53.6/10^6 "Partial molar volume of alcohol";
parameter Real V_2(unit = "'m^3/mol") = 18/10^6 "Partial molar volume of water";
parameter Real M1(unit = "kg/kmol") = 46 "Molar mass of ethanol";
parameter Real M2(unit = "kg/kmol") = 18 "Molar mass of water";

//============
//Variable Section
Real n1(unit = "mol") "Moles of ethanol in mixture";
Real n2(unit = "mol") "Moles of water in mixture";
Real x1(unit = "-") "Mole fraction of ethanol";
Real x2(unit = "-") "Mole fraction of water";
Real Va(unit = "m^3") "Actual volume of solution";
Real V1a(unit = "m^3") "Actual volume of ethanol required";
Real V2a(unit = "m^3") "Actual volume of water required";

//============
//Equation Section
equation
n1 = (V1*rho1)/(M1/10^3);
n2 = (V2*rho2)/(M2/10^3);
x1 = n1/(n1+n2);
x2 = 1-x1;
Va = (n1*V_1)+(n2*V_2);
V1a = (V1/Va)*Vt;
V2a = (V2/Va)*Vt;

end Ex7_2;

//===================================================
