//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.21 Page 315
//Title: Free energy of mixing
//===================================================

model Ex7_21


//============
//Parameter Section
parameter Real n1(unit = "moles") = 3 "Moles of hydrogen";
parameter Real n2(unit = "mole") = 1 "Mole of nitrogen";
parameter Real T(unit = "K") = 298 "Temperature";
parameter Real P1(unit = "bar") = 1 "Pressure of hydrogen";
parameter Real P2(unit = "bar") = 3 "Pressure of nitrogen";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real V1(unit = "m^3") "Volume of hydrogen";
Real V2(unit = "m^3") "Volume of nitrogen";
Real n(unit = "moles") "Total moles";
Real P(unit = "bar") "Final pressure attained by the mixture";
Real delta_G1(unit = "J") "Free energy change due to change in pressure";
Real x1(unit = "-") "Mole fraction of hydrogen";
Real x2(unit = "-") "Mole fraction of nitrogen";
Real delta_G2(unit = "J") "Free energy of mixing";
Real delta_G(unit = "kJ") "Total change in free energy";

//============
//Equation Section
equation
V1 = (n1*R*T)/(P1*10^5);    //Ideal gas law
V2 = (n2*R*T)/(P2*10^5);
n = n1+n2;
P = (n*R*T)/((V1+V2)*10^5);
//Step 1: Gases are brought to final pressure at constant temperature
delta_G1 = R*T*(n1*log(P/P1)+n2*log(P/P2));   
x1 = n1/(n1+n2);
x2 = 1-x1;
//Step 2 : Mixing at constant pressure and temperature
delta_G2 = n*R*T*(x1*log(x1)+x2*log(x2));   //Eqn. 7.121  pg no. 311
delta_G = (delta_G1+delta_G2)/10^3;   //Converting J to kJ

end Ex7_21;

//===================================================
