//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.3 Page 278
//Title: Partial molar properties and properties of solutions
//===================================================

model Ex7_3

//============
//Parameter Section
parameter Real x1(unit = "%") = 30 "Percent by mole of methanol-water solution";
parameter Real nV1(unit = "m^3/mol") = 40.727/10^6 "Molar Volume of methanol";
parameter Real nV2(unit = "m^3/mol") = 18.068/10^6 "Molar Volume of water";
parameter Real Vt(unit = "m^3") = 2 "Volume of solution";
parameter Real V_1(unit = "m^3/mol") = 38.632/10^6 "Partial molar volume of methanol";
parameter Real V_2(unit = "'m^3/mol") = 17.765/10^6 "Partial molar volume of water";

//============
//Variable Section
Real V(unit = "m^3/mol") "Molar volume of the desired solution";
Real n(unit = "mol") "Moles of the desired solution";
Real n1(unit = "mol") "Moles of methanol";
Real n2(unit = "mol") "Moles of water";
Real V1(unit = "'m^3") "Volume of methanol to be taken";
Real V2(unit = "'m^3") "Volume of water to be taken";

//===========
//Equation Section
equation
V = ((x1/100)*V_1)+((1-(x1/100))*V_2);
n = Vt/V;
n1 = n*(x1/100);
n2 = n*(1-(x1/100));
V1 = n1*nV1;
V2 = n2*nV2;

end Ex7_3;

//===================================================
