//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.7 Page 283
//Title: Partial Molar Volume
//===================================================

model Ex7_7

//============
//Parameter Section
parameter Real m(unit = "mol/kg") = 0.1 "Molality";
parameter Real M(unit = "kg/kmol") = 18 "Molecular weight of water";

//============
//Variable Section
Real V_1(unit = "m^3/mol") "Partial molar volume of NaCl";
Real V(unit =  "m^3") "Volume of solution";
Real V_2(unit = "m^3/mol") "Partial molar volume of water";

//============
//Equation Section
equation
V_1 = (0.1662/10^4)+((0.2655/10^5)*m^0.5)+((0.24/10^6)*m);    //Expression after differentiating Eqn. 7.29
V = (1.003/10^3)+((0.1662/10^4)*m)+((0.177/10^5)*m^1.5)+((0.12/10^6)*m^2);    //using Eqn. 7.29 pg no. 283
V_2 = (V-(m*V_1))*(M/1000);

end Ex7_7;

//===================================================
