//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.10 Page 361
//Title: Vapour liquid equilibrium
//===================================================


package Ex8_10

model Ex8_10_a

//=============
//Parameter Section
parameter Real P(unit = "kPa")  = 101.3 "Total pressure";
parameter Real T[6](unit = "K") = {371.4,378,383,388,393,398.6} "Temperature";
parameter Real PAs[6](unit = "kPa") = {101.3,125.3,140.0,160.0,179.9,205.3} "Vapour pressure of n-Heptane";
parameter Real PBs[6](unit = "kPa") = {44.4,55.6,64.5,74.8,86.6,101.3} "Vapour pressure of n-Octane";

//=============
//Variable Section
Real xA[6](unit = "-") "Composition of n-Heptane in liquid";
Real yA[6](unit = "-") "Composition of n-Heptane in vapour";
Real alpha[6](unit = "-") "Relative volatility";

//=============
//Equation Section
equation
for i in 1:6 loop
P = PBs[i]+xA[i]*(PAs[i]-PBs[i]);
yA[i] = (xA[i]*PAs[i])/P;
alpha[i] = PAs[i]/PBs[i];
end for;

//a.Plot of T vs x and y gives boiling point diagram
//b.Plot of y against x gives the equilibrium diagram

end Ex8_10_a;

end Ex8_10;

//===================================================

