//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.20 Page 380
//Title: P-x-y diagram
//===================================================

model Ex8_20

//============
//Parameter Section
parameter Real T(unit = "K") = 313 "Temperature";
parameter Real P1s(unit = "kPa") = 24.62 "Vapour pressure of cyclohexane";
parameter Real P2s(unit = "kPa") = 24.41 "Vapour pressure of benzene";


//============
//Variable Section
Real x1[6](each unit = "-") "Mole fraction of cyclohexane in liquid";
Real x2[6](each unit = "-") "Mole fraction of benzene in liquid";
Real gamma1[6](each unit = "-")"Activity coefficient of cyclohexane";
Real gamma2[6](each unit = "-")"Activity coefficient of benzene";
Real P[6](each unit = "kPa") "Total pressure";
Real y1[6](each unit = "-") "Mole fraction of cyclohexane in vapour";

//============
//Equation Section
equation
x1 = {0,0.2,0.4,0.6,0.8,1};   
for i in 1:6 loop
x2[i] = 1-x1[i];
log(gamma1[i]) = 0.458 *x2[i]^2;    //Given equation
log(gamma2[i]) = 0.458 *x1[i]^2;
P[i] = (gamma1[i]*x1[i]*P1s)+(gamma2[i]*x2[i]*P1s);
y1[i] = (gamma1[i]*x1[i]*P1s)/P[i];

end for;

end Ex8_20;

//===================================================
