//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.21 Page 381
//Title: Composition and total pressure of azeotrope
//===================================================

model Ex8_21

//============
//Parameter Section
parameter Real T(unit = "K") = 318  "Temperature";
parameter Real P(unit = "kPa") = 40.25 "Pressure";
parameter Real y1(unit = "-") = 0.566 "Mole fraction of benzene in vapour";
parameter Real x1(unit = "-") = 0.384 "Mole fraction of benzene in liquid";
parameter Real P1s(unit = "kPa") = 29.6 "Vapour prssure of benzene";
parameter Real P2s(unit = "kPa") = 22.9 "Vapour pressure of ethanol";

//============
//Variable Section
Real y2(unit = "-") "Mole fraction of ethanol in vapour";
Real x2(unit = "-") "Mole fraction of ethanol in liquid";
Real gamma1(unit = "-") "Activity coefficient of benzene";
Real gamma2(unit = "-") "Activity coefficient of ethanol";
Real A(unit = "-") "Van Laar constant";
Real B(unit = "-") "Van Laar Constant";
Real gamma1_a(unit = "-") "Activity coefficient of benzene at azeotropic composition";
Real gamma2_a(unit = "-") "Activity coefficient of ethanol at azeotropic composition";
Real x1_a(unit = "-") "Azeotropic composition of benzene";
Real P1(unit = "kPa") "Pressure at azeotropic condition";
Real P2(unit = "kPa") "Pressure at azeotropic condition";
Real P_a(unit = "kPa") "Total pressure of the azeotrope";


//============
//Equation Section
equation
y2 = 1-y1;
x2 = 1-x1;
gamma1 = (y1*P)/(x1*P1s);
gamma2 = (y2*P)/(x2*P2s);
A = log(gamma1)*(1+((x2*log(gamma2))/(x1*log(gamma1))))^2;
B = log(gamma2)*(1+((x1*log(gamma1))/(x2*log(gamma2))))^2;
x1_a = 0.6;
log(gamma1_a) = (A*(1-x1_a)^2)/(((A/B)*x1_a)+(1-x1_a))^2;
log(gamma2_a) = (B*x1_a^2)/(x1_a+((B/A)*(1-x1_a)))^2;
P1 = gamma1_a*P1s;
P2 = gamma2_a*P2s;
P_a = (P1+P2)/2;

end Ex8_21;

//===================================================
