//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.23 Page 383
//Title: Composition of vapour and liquid
//===================================================

package Ex8_23

model Ex8_23_a

//============
//Parameter Section
parameter Real a12(unit = "J/mol") = 1225.31 "Difference in characteristic energies";
parameter Real a21(unit = "J/mol") = 6051.01 "Difference in characteristic energies";
parameter Real V1(unit = "m^3/mol") = 74.05/10^6 "Molar volume of acetone";
parameter Real V2(unit = "m^3/mol") = 18.07/10^6 "Molar volume of water";
parameter Real A1(unit = "-") = 14.39155 "Antoine eqn constant of acetone";
parameter Real B1(unit = "-") = 2795.817 "Antoine eqn constant of acetone";
parameter Real C1(unit = "-") = 43.198 "Antoine eqn constant of acetone";
parameter Real A2(unit = "-") = 16.26205 "Antoine eqn constant of water";
parameter Real B2(unit = "-") = 3799.887 "Antoine eqn constant of water";
parameter Real C2(unit = "-") = 46.854 "Antoine eqn constant of water";
parameter Real x1a(unit = "-") = 0.43 "Liquid composition of acetone";
parameter Real T(unit = "-") = 349 "Temperature";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real P1s(unit = "kPa") "Vapour pressure of acetone";
Real P2s(unit = "kPa") "Vapour pressure of water";
Real lambda12(unit = "-") "Wilson parameter";
Real lambda21(unit = "-") "Wilson parameter";
Real x2a(unit = "-") "Mole fraction of water in liquid";
Real gamma1a(unit = "-") "Activiy coefficient of acetone at x1a = 0.43";
Real gamma2a(unit = "-") "Activity coefficient of water at x1a = 0.43";
Real Pa(unit = "kPa") "Pressure at x1a = 0.43";
Real y1a(unit = "-") "Vapour composition of acetone";

//============
//Equation Section
equation
log(P1s) = A1-(B1/(T-C1));    //Antoine equation
log(P2s) = A2-(B2/(T-C2));    ////Antoine equation
lambda12 = ((V2/V1)*exp(-(a12/(R*T))));
lambda21 = ((V1/V2)*exp(-(a21/(R*T))));
x2a = 1-x1a;
//Wilson equation
log(gamma1a) = -log(x1a+(lambda12*x2a))+(x2a*((lambda12/(x1a+(lambda12*x2a)))-(lambda21/((lambda21*x1a)+x2a))));    
log(gamma2a) = -log(x2a+(lambda21*x1a))+(x1a*((lambda21/(x2a+(lambda21*x1a)))-(lambda12/((lambda12*x2a)+x1a))));    
Pa = (x1a*gamma1a*P1s)+(x2a*gamma2a*P2s);
y1a = (gamma1a*x1a*P1s)/Pa;

end Ex8_23_a;

//============

model Ex8_23_b

extends Ex8_23_a;

//============
//Parameter Section
parameter Real y1b(unit = "-") = 0.8 "Vapour composition of acetone";

//============
//Variable Section
Real y2b(unit = "-") "Vapour composition of water";
Real Pi(unit = "kPa") "Pressure at ideal condition";
Real x1i(unit = "-") "Liquid composition of acetone at ideal state";
Real x2i(unit = "-") "Liquid composition of water at ideal state";
Real gamma1i(unit = "-") "Activiy coefficient of acetone at ideal state";
Real gamma2i(unit = "-") "Activity coefficient of water at ideal state";
Real Pb(unit = "kPa") "Pressure at y1b = 0.8";
Real x1b(unit = "-") "Liquid composition of acetone";
Real x2b(unit = "-") "Liquid composition of water";
Real gamma1b(unit = "-") "Activiy coefficient of acetone at y1b = 0.8";
Real gamma2b(unit = "-") "Activity coefficient of water at y1b = 0.8";

//============
//Equation Section
equation 
y2b = 1- y1b;
Pi = 1/((y1b/P1s)+((y2b/P2s)));
x1i = (y1b*Pi)/P1s;
x2i = 1-x1i;
log(gamma1i) = -log(x1i+(lambda12*x2i))+(x2i*((lambda12/(x1i+(lambda12*x2i)))-(lambda21/((lambda21*x1i)+x2i))));    
log(gamma2i) = -log(x2i+(lambda21*x1i))+(x1i*((lambda21/(x2i+(lambda21*x1i)))-(lambda12/((lambda12*x2i)+x1i))));    
Pb = 1/((y1b/(gamma1i*P1s))+(y2b/(gamma2i*P2s)));
x1b = (y1b*Pb)/(gamma1i*P1s);
x2b = 1-x1b;
log(gamma1b) = -log(x1b+(lambda12*x2b))+(x2b*((lambda12/(x1b+(lambda12*x2b)))-(lambda21/((lambda21*x1b)+x2b))));    
log(gamma2b) = -log(x2b+(lambda21*x1b))+(x1b*((lambda21/(x2b+(lambda21*x1b)))-(lambda12/((lambda12*x2b)+x1b))));    

end Ex8_23_b;

//============

end Ex8_23;
