//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.26 Page 392
//Title: Bubble point, dew point, temperature and composition
//===================================================

package Ex8_26

model Ex8_26_a

//============
//Parameter Section
parameter Real xi[3](each unit = "-") = {0.25,0.4,0.35} "Mole fraction of propane,n-butane and n-pentane in liquid"; 
parameter Real K1[3](each unit = "-") = {2,0.78,0.33}  "Factor at 355.4 K";
parameter Real K2[3](each unit = "-") = {2.3,0.9,0.4} "Factor at 366.5 K";
parameter Real Kb[3](each unit = "-") = {2.12,0.85,0.37} "Factor at 361 K";
parameter Real P(unit = "kPa") = 1447.14 "Pressure";

//============
//Variable Section
Real T1(unit = "K") "Temperature";
Real T2(unit = "K") "Temperature";
Real Kx1[3](each unit = "-") "Product of K1 and xi at 355.4 K";
Real Kx2[3](each unit = "-") "Product of K2 and xi at 366.5 K";
Real S_Kx1(unit = "-") "Sum of Kx1 at 355.4 K";
Real S_Kx2(unit = "-") "Sum of Kx2 at 366.5 K";
Real Tb(unit = "-")"Bubble point temperature";
Real yi[3](each unit = "%") "Vapour composition of propane,n-butane and n-pentane";

//============
//Equation Section
equation
T1 = 355.4;   //Assumed
T2 = 366.5;   //Assumed
for i in 1:3 loop
Kx1[i] = K1[i]*xi[i];
Kx2[i] = K2[i]*xi[i];
end for;

S_Kx1 = Kx1[1]+Kx1[2]+Kx1[3];
S_Kx2 = Kx2[1]+Kx2[2]+Kx2[3];
Tb = T2-(((S_Kx2-1)/(S_Kx2-S_Kx1))*(T2-T1));   //Interpolation

for i in 1:3 loop
yi[i] = (Kb[i]*xi[i])*100;
end for;

end Ex8_26_a;

//=============

model Ex8_26_b

//============
//Parameter Section
parameter Real yi[3](each unit = "-") = {0.25,0.4,0.35} "Mole fraction of propane,n-butane and n-pentane in vapour"; 
parameter Real K1[3](each unit = "-") = {2.6,1.1,0.5}  "Factor at 377.6 K";
parameter Real K2[3](each unit = "-") = {2.9,1.3,0.61} "Factor at 388.8 K";
parameter Real Kd[3](each unit = "-") = {2.85,1.25,0.59} "Factor at 387 K";

//============
//Variable Section
Real T1(unit = "K") "Temperature";
Real T2(unit = "K") "Temperature";
Real Ky1[3](each unit = "-") "Ratio of yi and K1 at 377.6 K";
Real Ky2[3](each unit = "-") "Ratio of yi and K2 at 388.8";
Real S_Ky1(unit = "-") "Sum of Ky1 at 377.6 K";
Real S_Ky2(unit = "-") "Sum of Ky2 at 388.8 K";
Real Td(unit = "-")"Dew point temperature";
Real xi[3](each unit = "%") "Liquid composition of propane,n-butane and n-pentane";

//============
//Equation Section
equation
T1 = 377.6;   //Assumed
T2 = 388.8;   //Assumed
for i in 1:3 loop
Ky1[i] = yi[i]/K1[i];
Ky2[i] = yi[i]/K2[i];
end for;

S_Ky1 = Ky1[1]+Ky1[2]+Ky1[3];
S_Ky2 = Ky2[1]+Ky2[2]+Ky2[3];
Td = T2-(((S_Ky2-1)/(S_Ky2-S_Ky1))*(T2-T1));   //Interpolation

for i in 1:3 loop
xi[i] = (yi[i]/Kd[i])*100;
end for;

end Ex8_26_b;

//============

model Ex8_26_c

//============
//Parameter Section
parameter Real zi[3](unit = "-") = {0.25,0.4,0.35} "Mole fraction of propane,n-butane and n-pentane"; 
parameter Real K1[3](unit = "-") = {2.3,0.9,0.4} "Factor at 366.5 K";
parameter Real K2[3](unit = "-") = {2.6,1.1,0.5}  "Factor at 355.4 K";
parameter Real Ke[3](unit = "-") = {2.5,1.08,0.48} "Factor at 374.6 K";
parameter Real v(unit = "%") = 45 "Mole percent of initial mixture vapourized";

//============
//Variable Section
Real F(unit = "mol") "Moles of initial mixture";
Real V(unit = "mol") "Moles of vapour";
Real L(unit = "mol") "Moles of liquid";
Real T1(unit = "K") "Temperature";
Real T2(unit = "K") "Temperature";
Real Kz1[3](unit = "-") "Equation of zi and K1 at 377.6 K";
Real Kz2[3](unit = "-") "Equation of zi and K2 at 388.8";
Real Kze[3](unit = "-") "Equation of zi and Ke at 374.6";
Real S_Kz1(unit = "-") "Sum of Kz1 at 377.6 K";
Real S_Kz2(unit = "-") "Sum of Kz2 at 388.8 K";
Real S_Kze(unit = "-") "Sum of Ky2 at 374.6 K";
Real Te(unit = "-")"Equilibrium temperature";
Real yi[3](unit = "-") "Vapour composition of propane,n-butane and n-pentane";
Real xi[3](unit = "-") "Liquid composition of propane,n-butane and n-pentane";


//============
//Equation Section
equation
T1 = 366.5;   //Assumed
T2 = 377.6;   //Assumed
F = 100;    //Basis
V = (v/100)*F;
L = F-V;

for i in 1:3 loop
Kz1[i] = zi[i]/(1+(L/(V*K1[i])));
Kz2[i] = zi[i]/(1+(L/(V*K2[i])));
end for;

S_Kz1 = Kz1[1]+Kz1[2]+Kz1[3];
S_Kz2 = Kz2[1]+Kz2[2]+Kz2[3];
Te = T2-(((S_Kz2-(v/100))/(S_Kz2-S_Kz1))*(T2-T1));   //Interpolation

for i in 1:3 loop
Kze[i] = zi[i]/(1+(L/(V*Ke[i])));
end for;

S_Kze = Kze[1]+Kze[2]+Kze[3];

for i in 1:3 loop
yi[i] = (zi[i]/(1+(L/(V*Ke[i]))))/S_Kze;
F*zi[i] = V*yi[i] +L*xi[i];
end for;

end Ex8_26_c;


end Ex8_26;
