//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.27 Page 400
//Title: Thermodynamic consistency of VLE
//===================================================

model Ex8_27

//=============
//Parameter Section
parameter Real P(unit = "kPa") = 101.3 "Total pressure";
parameter Real x1[4](each unit = "-") = {0.003,0.449,0.7,0.9} "Mole fraction of ethanol in liquid";
parameter Real y1[4](each unit = "-") = {0.432,0.449,0.520,0.719} "Mole fraction of ethanol in vapour";
parameter Real P1s[4](each unit = "kPa") = {65.31,63.98,66.64,81.31} "Vapour pressure of ethanol";
parameter Real P2s[4](each unit = "kPa") = {68.64,68.64,69.31,72.24} "Vapour pressure of benzene";

//============
//Variable Section
Real gamma1[4](each unit = "-") "Activity coefficient of ethanol";
Real gamma2[4](each unit = "-") "Activity coefficient of benzene";
Real ratio[4](each unit = "-") "Logarithmic ratio of activity coefficients";

//===========
//Equation Section
equation
for i in 1:4 loop
gamma1[i] = (y1[i]*P)/(x1[i]*P1s[i]);
gamma2[i] = ((1-y1[i])*P)/((1-x1[i])*P2s[i]);
ratio[i] = log(gamma1[i]/gamma2[i]);

end for;

//Answer provided in the book is wrong for activity coefficient and its ratio of benzene at y1=0.719

end Ex8_27;

//===================================================
