//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.29 Page 402
//Title: Constants in Margules Equation
//===================================================

model Ex8_29

//============
//Parameter Section
parameter Real T(unit = "K") = 328 "Temperature";
parameter Real x1[2](each unit = "-") = {0.0331,0.9652} "Mole fraction of chloroform";
parameter Real P[2](each unit = "kPa") = {40.84, 84.88} "Total pressure";
parameter Real P1s(unit = "kPa") = 82.35 "Vapour pressure of chloroform";
parameter Real P2s(unit = "kPa") = 37.30 "Vapour pressure of acetone";

//=============
//Variable Section
Real gamma1_inf(unit = "-") "Activity coefficient of chloroform at infinite dilution";
Real gamma2_inf(unit = "-") "Activity coefficient of acetone at infinite dilution";
Real A(unit = "-") "Constant in Margules equation";
Real B(unit = "-") "Constant in Margules equation";

//=============
//Equation Section
equation
gamma1_inf = (P[1]-((1-x1[1])*P2s))/(x1[1]*P1s);    //As x2 tend to 1 Eqn. 8.103 Carlson relation
gamma2_inf = (P[2]-(x1[2])*P1s)/((1-x1[2])*P2s);    //As x1 tends to 1 Eqn. 8.104 Colburn relation
A = log(gamma1_inf);
B = log(gamma2_inf);

end Ex8_29;

//===================================================
