//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.30 Page 403
//Title: Partial pressure of water in vapour phase
//===================================================

model Ex8_30

//============
//Parameter Section
parameter Real T(unit = "K") = 333 "Temperature";
parameter Real x1[7](each unit = "-") =  {0,0.033,0.117,0.318,0.554,0.736,1.000} "Mole fraction of acetone in liquid";
parameter Real p1[7](each unit = "kPa") = {0,25.33,59.05,78.37,89.58,94.77,114.63} "Partial pressure of acetone";
parameter Real P2s(each unit = "kPa") = 19.91 "Vapour pressure of water at 333 K";

//============
//Variable Section
Real k[6](each unit = "-") "Area under the curve";
Real p2[7](each unit = "kPa") "Partial pressure of water in vapour phase";

//============
//Equation Section
equation
k[1] = 0;
for i in 2:6 loop
k[i] = (x1[i]/((1-x1[i])*p1[i]));   //Using integral expression from Eqn. 5.106
end for;

p2 = {19.91,19.31,18.27,16.99,15.42,13.90,0};   //Value is obtained after integration 

end Ex8_30;

//===================================================
