//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.32 Page 407
//Title: Temperature composition diagram
//===================================================

model Ex8_32

//============
//Parameter Section
parameter Real Tb(unit = "K") = 353.1 "Boiling point temperature";
parameter Real Pb(unit = "kPa") = 101.3 "Pressure at 353.1 K";
parameter Real T[7](each unit = "K") = {323,333,343,348,353,363,373} "Temperature";
parameter Real P2s[7](each unit = "kPa") = {12.4,19.86,31.06,37.99,47.32,70.11,101.3} "Vapour pressure of water";
parameter Real P1s[7](each unit = "kPa") = {35.85,51.85,72.91,85.31,100.50,135.42,179.14} "Vapour pressure of benzene";

//============
//Variable Section
Real Tt(unit = "K") "Three phase temperature at 101.3 kPa";
Real P1s_t(unit = "kPa") "Vapour pressure of benzene at three phase temperature";
Real P2s_t(unit = "kPa") "Vapour pressure of water at three phase temperature";
Real y1_t(unit = "-")  "Mole fraction of benzene at three phase temperature";
Real y1[7](unit = "-") "Mole fraction of benzene in vapour for curve BE";
Real y_1[5](unit = "-")"Mole fraction of benzene in vapour for curve AE";

//=============
//Equation Section
equation
Tt = 342;     //From graph between P and T ref pg no. 407
P1s_t = 71.18;
P2s_t = 30.12;
y1[1] = 0;       //Value is given to satisfy array condition
y1[2] = 0;       //Value is given to satisfy array condition
y_1[1] = 0;     //Value is given to satisfy array condition
y_1[2] = 0;     //Value is given to satisfy array condition
y1_t = P1s_t/Pb;
//Dew point curve BE is plotted by choosing temperature between 373K(boiling point of water) and 342 K(Three-phase temperature)
for i in 3:7 loop
P2s[i] = (1-y1[i])*Pb;    //Partial pressure equals vapour pressure in BE curve
end for;

//Dew point curve AE is plotted by choosing temperature between 353.1K(boiling point of benzene) and 342 K(Three-phase temperature)
for i in 3:5 loop
P1s[i] = Pb*y_1[i];   //Partial pressure equals vapour pressure in AE curve
end for;

end Ex8_32;
