//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.6 Page 357
//Title: Composition of vapour and liquid
//===================================================

model Ex8_6

//============
//Parameter Section
parameter Real T(unit = "K") = 373 "Temperature of the solution";
parameter Real P(unit = "kPa") = 101.3 "Pressure of the solution";
parameter Real P1s(unit = "kPa") = 106 "Vapour pressure of n-heptane";
parameter Real P2s(unit = "kPa") = 74 "Vapour pressure of toluene";

//============
//Variable Section
Real x(unit = "-") "Mole fraction of heptane in liquid";
Real y(unit = "-") "Mole fraction of heptane in vapour";
Real xp(unit = "%") "Per cent by mole of heptane in liquid";
Real yp(unit = "%") "Per cent by mole of heptane in vapour";

//============
//Equation Section
equation
P = P2s + (P1s-P2s)*x;    //From Eqn. 8.51 pg no. 353
y = (x*P1s)/P;    //From Eqn. 8.54 pg no. 353, Raoult's law
xp = x*100;   //Converting mole fraction to mole per cent
yp = y*100;

end Ex8_6;

//===================================================
