//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 8: Phase Equilibria
//Example: 8.8 Page 357
//Title: Composition of vapour
//===================================================

model Ex8_8

//============
//Parameter Section
parameter Real A1(unit = "-") = 14.27 "Component 1 Antoine eqn. constant";
parameter Real B1(unit = "-") = 2945 "Component 1 Antoine eqn. constant";
parameter Real C1(unit = "-") = 49 "Component 1 Antoine eqn. constant";
parameter Real A2(unit = "-") = 14.2 "Component 2 Antoine eqn. constant";
parameter Real B2(unit = "-") = 2973 "Component 2 Antoine eqn. constant";
parameter Real C2(unit = "-") = 64 "Component 2 Antoine eqn. constant";
parameter Real T(unit = "K")  = 349 "Bubble point of the mixture";
parameter Real P(unit = "kPa") = 80 "Total pressure";

//============
//Variable Section
Real PAs(unit = "kPa") "Vapour pressure of component 1";
Real PBs(unit = "kPa") "Vapour pressure of component 2";
Real xA(unit = "-") "Composition of liquid";
Real yA(unit = "-") "Composition of vapour";

//============
//Equation Section
equation
log(PAs) = A1-(B1/(T-C1));    //Antoine equation
log(PBs) = A2-(B2/(T-C2));    //Antoine equation
xA = (P-PBs)/(PAs-PBs);     //From Eqn.8.51 pg no.353
yA = (xA*PAs)/P;       //From Eqn.8.54 pg no.353

end Ex8_8;

//===================================================
