//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.12 Page 448
//Title: Fraction of CO converted to CH3OH
//===================================================

model Ex9_12

//CO(g)+2H2(g) = CH3OH(g)

//============
//Parameter Section
parameter Real delta_G(unit = "kJ") = -1.3484 "Free energy of reaction at 400 K";
parameter Real n_CO(unit = "mol") = 1 "Moles of CO";  //Basis
parameter Real n_H2(unit = "mol") = 1 "Moles of H2";
parameter Real T(unit = "K") = 400 "Inlet temperature of the reactants";
parameter Real P(unit = "bar") = 10 "Inlet pressure of the reactants";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 2 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of CH3OH";

//============
//Variable Section
Real K(unit = "-") "Equilibrium constant";
Real Ky(unit = "-") "Equilibrium constan in terms of composition";
Real epsilon(unit = "-") "Extent of reaction";
Real z(unit = "-") "Fraction of CO converted";

//============
//Equation Section
equation
K = exp(-(delta_G*10^3)/(R*T));   //Using Eqn. 9.31 pg no.433
Ky = K*P^2;   //Using Eqn. 9.63 pg no.447
Ky = (4*epsilon*(1-epsilon))/((1-2*epsilon)^2);
z = (a*epsilon)/n_CO;

end Ex9_12;

//===================================================
