//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.13 Page 448
//Title: Polymeric unit
//===================================================

model Ex9_13

//Ex9_13_b

//============
//Parameter Section
parameter Real T(unit = "K") = 300 "Temperature";
parameter Real P1(unit = "bar") = 1 "Pressure";
parameter Real P2(unit = "bar") = 2 "Pressure";
parameter Real y1_Mn(unit = "-") = 0.15 "Mole fraction of polymer at 1 bar";
parameter Real y2_Mn(unit = "-") = 0.367 "Mole fraction of polymer ar 2 bar";

//============
//Variable Section
Real n(unit = "-") "Number of monomeric units";

//============
//Equation Section
equation
//Ky = mole fraction of Mn/(mole fraction of M)^n = K*P^(n-1)
//Dividing the equations and taking log on both sides
(n-1)*log(P2) = log(y2_Mn/y1_Mn)+(n*log((1-y1_Mn)/(1-y2_Mn)));    //Ref. pg no. 449

end Ex9_13;

//===================================================
