//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.14 Page 449
//Title: Conversion of nitrogen to ammonia
//===================================================

package Ex9_14

//N2+3H2 ----> 2NH3

model Ex9_14_a

//=============
//Parameter Section
parameter Real K(unit = "-") = 2/10^4 "Equilibrium constant";
parameter Real T(unit = "K")  = 675 "Temperature";
parameter Real P1(unit = "bar") = 20 "Pressure";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of N2";
parameter Real b(unit = "-") = 3 "Stoichiometric coefficient of H2";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of NH3";


//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric numbers";
Real n_N2(unit = "mol") "Moles of nitrogen in reactant";
Real n_H2(unit = "mol") "Moles of hydrogen in reactant";
Real K_phi(unit = "-") "Equilibrium constant in terms of fugaciy coefficient";
Real epsilon1(unit = "-") "Extent of the reaction at 20 bar";
Real z1(unit = "%") "Percentage conversion of nitrogen at 20 bar";


//=============
//Equation Section
equation
n_N2 = 1;   //Basis
n_H2 = 3;   //Basis
nu = c-a-b;
K_phi = 1;    //Ideal behaviour is assumed
n = n_N2+n_H2;
((c*epsilon1)^2*((n+(nu*epsilon1))^(-nu)))/((n_N2-(a*epsilon1))^a*(n_H2-(b*epsilon1))^b) = K*P1^2;
z1 = (a*epsilon1)/n_N2*100;

end Ex9_14_a;

//=============

model Ex9_14_b

extends Ex9_14_a;

//=============
//Parameter Section
parameter Real P2(unit = "bar") = 200 "Pressure";

//============
//Variable Section
Real epsilon2(unit = "-") "Extent of the reaction at 200 bar";
Real z2(unit = "%") "Percentage conversion of nitrogen at 200 bar";


//=============
//Equation Section
equation
((c*epsilon2)^2*((n+(nu*epsilon2))^(-nu)))/((n_N2-(a*epsilon2))^a*(n_H2-(b*epsilon2))^b) = K*P2^2;
z2 = (a*epsilon2)/n_N2*100;

end Ex9_14_b;

//=============

//Increase in pressure favours the formation of ammonia

end Ex9_14;
