//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.19 Page 456
//Title: Composition of mixture
//================================================

model Ex9_19

//C2H4(g)+H2O(g) ----> C2H5OH(g)

//============
//Parameter Section
parameter Real na1(unit = "mol") = 1 "Moles of ethylene in reactant";
parameter Real nb1(unit = "mol") = 3 "Moles of steam in reactant";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of ethylene";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of steam";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of ethanol";
parameter Real T(unit = "K")  = 400 "Temperature";
parameter Real P(unit = "bar") = 2 "Pressure";
parameter Real K(unit = "-") = 0.25 "Equilibrium constant of the reaction";
parameter Real na2(unit = "mol") = 1 "Moles of ethylene";
parameter Real nb2(unit = "mol") = 1 "Moles of steam";

//============
//Variable Section
Real n1(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric coefficients";
Real Ky(unit = "-") "Equilibrium constant based on composition";
Real epsilon1(unit = "-") "Extent of reaction in 1:3 ratio of reactants";
Real c1(unit = "%") "Conversion of ethylene in 1:3 ratio of reactants";
Real xa1(unit =  "%") "Mole percent of ethylene in 1:3 ratio of reactants";
Real xb1(unit =  "%") "Mole percent of steam in 1:3 ratio of reactants";
Real xc1(unit =  "%") "Mole percent of ethanol in 1:3 ratio of reactants";
Real n2(unit = "mol") "Total moles";
Real epsilon2(unit = "-") "Extent of reaction in stoichiometric quantity of reactants";
Real c2(unit = "%") "Conversion of ethylene in 1:3 stoichiometric quantity of reactants";

//============
//Equation Section
equation
n1 = na1+nb1;
nu = c-a-b;
K = Ky*(P^nu);    //Ideal gas, so kphi = 1
Ky = ((c*epsilon1)^c*(n1+(nu*epsilon1))^(-nu))/((na1-(a*epsilon1))^a*(nb1-(b*epsilon1))^b);
xa1 = (na1-(a*epsilon1))/(n1+(nu*epsilon1))*100;    //Mole fraction
xb1 = (nb1-(b*epsilon1))/(n1+(nu*epsilon1))*100;
xc1 = (c*epsilon1)/(n1+(nu*epsilon1))*100;
n2 =  a+b;    //Stoichiometric quantities of reactants
Ky = ((c*epsilon2)^c*(n2+(nu*epsilon2))^(-nu))/((na2-(a*epsilon2))^a*(nb2-(b*epsilon2))^b);
c1 = epsilon1*100;
c2 = epsilon2*100;

end Ex9_19;

//================================================
