//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.20 Page 457
//Title: Effect of presence of product on equilibrium conversion
//================================================

model Ex9_20

//CO(g)+H2O(g) ----> CO2(g)+H2(g)

//============
//Parameter Section
parameter Real na(unit = "mol") = 1 "Moles of carbon monoxide";
parameter Real nb(unit = "mol") = 1 "Moles of water vapour";
parameter Real nc(unit = "mol") = 1 "Moles of carbon dioxide";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of H2O";
parameter Real c(unit = "-") = 1 "Stoichiometric coefficient of CO2";
parameter Real d(unit = "-") = 1 "Stoichiometric coefficient of H2";
parameter Real T(unit = "K")  = 1100 "Temperature";
parameter Real P(unit = "bar") = 1 "Pressure";
parameter Real K(unit = "-") = 1 "Equilibrium constant";

//============
//Variable Section
Real n(unit = "mol") "Total moles";
Real nu(unit = "-") "Sum of stoichiometric coefficients";
Real Ky(unit = "-") "Equilibrium constant based on composition";
Real epsilon(unit = "-") "Extent of reaction ";


//============
//Equation Section
equation
n = na+nb+nc;
nu = c+d-a-b;
Ky = K*P^nu;    ////Ideal gas, so kphi = 1
Ky = ((nc+(c*epsilon))^c*(d*epsilon)^d)/((na-(a*epsilon))^a*(nb-(b*epsilon))^b);

//Presence of product reduced the conversion

end Ex9_20;

//================================================
