//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 9: Chemical Reaction Equilibria
//Example: 9.23 Page 462
//Title: Evaluation of equilibrium constant
//================================================

model Ex9_23

//C2H4(g)+H2O(l) ----> C2H5OH(aq)

//============
//Parameter Section
parameter Real T(unit = "K")  = 530 "Temperature";
parameter Real P(unit = "bar") = 85 "Pressure";
parameter Real p_C2H4(unit = "%") = 48 "Mole percent of ethylene in vapour phase";
parameter Real p_H2O(unit = "'%") = 95 "Aqueous phase mole percent of water";
parameter Real p_C2H5OH(unit = "'%") = 1.5 "Aqueous phase mole percent of ethanol";
parameter Real phi_C2H4(unit = "-") = 0.9 "Fugacity coefficient of ethylene";
parameter Real M(unit = "'kg/kmol") = 18 "Molecular mass of water";

//============
//Variable Section
Real y_C2H4(unit = "-") "Mole fraction of ethylene";
Real x_H2O(unit = "-") "Mole fraction of water";
Real m(unit = "mol/kg water") "Molality of aqueous solution";
Real f_C2H4(unit = "bar") "Fugacity of ethylene";
Real gamma_H2O(unit = "-") "Activity coefficient of water";
Real K(unit = "mol C2H4/kg water bar") "Equilibrium constant";

//============
//Equation Section
equation
y_C2H4 = p_C2H4/100;
x_H2O = p_H2O/100;
m = p_C2H5OH/(p_H2O*M/10^3);      //Converting kmol to mol
f_C2H4 = (phi_C2H4*y_C2H4*P);
gamma_H2O = 1;      //Raoult's law is considered
K = m/(f_C2H4*x_H2O);   // Using Eqn.9.73 p.461

end Ex9_23;

//================================================
