//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.2 Page 6
//Title: Height of fluid in manometer
//===================================================

model Ex1_2

//============
//Parameter Section
parameter Real P1(unit = "bar") = 1.15 "Measured Pressure";
parameter Real P2(unit = "mmHg") = 760 "Atmospheric Pressure"; 
parameter Real sg(unit = "-") = 2.95 "Specific gravity of the fluid";
parameter Real g(unit  = "m/s^2") = 9.8067 "Acceleration due to gravity";

//============
//Variable Section
Real deltaP(unit = "  N/m^2") "Difference in Pressure";
Real h(unit = "mm") "Height of fluid in manometer";

//============
//Equation Section
equation
deltaP = (P1*10^5)-((P2/760)*101325);   //1 bar = 10^5 N/m^2 and 760 mmHg = 101325 N/m^2
h =(deltaP)/(sg*1000*g)*10^3;    //specific gravity is converted to density

end Ex1_2;

//===================================================

