//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.7 Page 19
//Title: Work done on surrounding 
//===================================================

model Ex1_7

//============
//Parameter Section

parameter Real mg(unit = "kg") = 2 "Mass of CO2 gas";
parameter Real P(unit = "bar") = 6.5 "Pressure of gas in piston-cylinder assembly";
parameter Real T(unit = "K") = 300 "Temperature of gas in piston-cylinder assembly";
parameter Real mp(unit = "kg") = 5000 "Mass of  the piston";
parameter Real AP(unit = "bar") = 1.01325 "Atmospheric pressure";
parameter Real g(unit = "kg/m^2") = 9.8067 "Acceleration due to gravity";
parameter Real M(unit  = "kg/kmol") = 44 "Molecular weight of CO2";
parameter Real R(unit = "J/(mol.K)") = 8.314 "Universal gas constant";

//============
//Variable Section
Real n(unit = "kmol") "No. of moles of CO2";
Real IV(unit = "m3") "Initial Volume";
Real FV(unit = "m3") "Final Volume";
Real deltaV(unit = "m3") "Change in Volume";
Real PS(unit = "N/m2") "Pressure on the surrounding";
Real W(unit = "J") "Work done on the surrounding";

//============
//Equation Section 
equation
n = mg/M;
IV = (n*R*10^3*T)/(P*10^5);   //Assuming gas follows ideal gas equation
FV = 2*IV;
deltaV = FV-IV;
PS = (AP*10^5+(mp*g));    //Atmospheric pressure is converted from bar to Pa
W = PS*deltaV;

end Ex1_7;
