package Ex2_17
  //Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
  //Chapter 2: First Law of Thermodynamics
  //Example: 2.17 Page 42
  //Title: Const. volume and const. pressure process
  //===================================================

  model Ex2_17_a
  
  //=============
  //Parameter Section
  parameter Real m(unit = "kg") = 10 "Mass of air";
  parameter Real P1(unit = "kPa") = 100 "Initial pressure";
  parameter Real T1(unit = "K") = 300 "Initial temperature";
  parameter Real T2(unit = "K") = 600 "Final temperature";
  parameter Real R(unit = "kJ/kmol K") = 8.314 "Ideal gas constant";
  parameter Real Cp(unit = "kJ/kmol K") = 29.099 "Specific heat at const. pressure";
  parameter Real Cv(unit = "kJ/kmol K") = 20.785 "Specific heat at const. pressure";
  parameter Real M(unit = "kg/kmol") = 29 "Molecular weight of air";
    
  //============
  //Variable Section
  Real n(unit = "kmol") "Number of moles of gas";
  Real V1(unit = "m^3") "Initial volume of gas";
  Real V2a(unit = "m^3") "Final volume of gas in const. volume process";
  Real delta_U1(unit = "kJ") "Change in internal energy in const. volume process";
  Real Q1(unit = "kJ") "Heat transferred in const. volume process";
  Real W1(unit = "kJ") "Work done in const. volume process";
  Real delta_H1(unit = "kJ") "Change in enthalpy in const. volume process";
    
  //=============
  //Equation Section
  equation
  n = m / M;
  V1 = n * R * T1 / P1; //Ideal gas law
  V2a = V1; // Constant volume process
  delta_U1 = n * Cv * (T2 - T1);
  Q1 = delta_U1;
  W1 = Q1-delta_U1;
  delta_H1 = delta_U1 + n * R * (T2 - T1);
  
  end Ex2_17_a;

  //=============

  model Ex2_17_b
  
  extends Ex2_17_a;
  
  //============
  //Variable Section
  Real P2(unit = "kPa") "Final pressure";
  Real V2b(unit = "m^3") "Final volume of gas in const. pressure process";
  Real delta_U2(unit = "kJ") "Change in internal energy in const. pressure process";
  Real Q2(unit = "kJ") "Heat transferred inr const. pressure process";
  Real W2(unit = "kJ") "Work done in const. pressure process";
  Real delta_H2(unit = "kJ") "Change in enthalpy in const. pressure process";
  
  //============
  //Equation Section
  equation
  P2 = P1; //Constant pressure process
  delta_H2 = n * Cp * (T2 - T1);
  Q2 = delta_H2;
  delta_U2 = delta_H2 - n * R * (T2 - T1);
  W2 = Q2 - delta_U2;
  V2b = n * R * T2 / P2;
  
  end Ex2_17_b;

  //============
end Ex2_17;
