//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.18 Page 42
//Title: Change in internal energy and enthalpy
//===================================================

model Ex2_18

//============
//Parameter Section
parameter Real R(unit = "kJ/kmol K") = 8.314 "Universal gas constant";
parameter Real Cv(unit = "kJ/kmol K") = 20.8 "Heat capacity at constant volume";
parameter Real Cp(unit = "kJ/kmol K") = 29.1 "Heat capacity at constant pressure";
parameter Real P1(unit = "bar") = 10 "Initial pressure of gas";
parameter Real T1(unit = "K") = 280 "Initial temperature of gas";
parameter Real P2(unit = "bar") = 1 "Final pressure of gas";
parameter Real T2(unit =  "K") = 340 "Final temperature of gas";
parameter Real n(unit = "kmol")= 1 "Moles of Nitrogen";    //Basis
//============
//Variable Section
Real V1(unit = "m^3") "Initial volume of gas";
Real V2(unit = "m^3") "Final volume of gas";
Real T(unit = "K") "Intermediate temperature";
Real delta_U1(unit = "kJ") "Internal energy in const. volume process";
Real delta_H1(unit = "kJ") "Enthalpy in const. volume process";
Real Q1(unit = "kJ") "Heat added in const.volume process";
Real W1(unit = "kJ") "Work done const.volume process ";
Real delta_U2(unit = "kJ") "Internal energy in const. pressure process";
Real delta_H2(unit = "kJ") "Enthalpy in const. pressure process";
Real Q2(unit = "kJ") "Heat added in const. pressure process";
Real W2(unit = "kJ") "Work done  in const. pressure process";
Real delta_U(unit = "kJ") "Change in internal energy";
Real delta_H(unit = "kJ") "Change in enthalpy";

//============
//Equation Section  
equation
V1 = (n*R*T1)/(P1*100);     //Ideal gas equation, Pressure is converted to kPa
V2 = (n*R*T2)/(P2*100);
T = (P2*100*V1)/(n*R);      //Constant volume process
delta_U1 = Cv*(T-T1);
delta_H1 = delta_U1+V1*((P2 - P1)*100);
W1 = 0;
Q1 = delta_U1;
delta_H2 = Cp*(T2-T);    //Constant pressure process
delta_U2 = delta_H2-(P2*100)*(V2-V1);
Q2 = delta_H2;
W2 = Q2-delta_U2;
delta_U = delta_U1+delta_U2;
delta_H = delta_H1+delta_H2;


end Ex2_18;

//===================================================
