//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.4 Page 28
//Title: Change in internal energy during each step and work done during adiabatic process
//===================================================

model Ex2_4

//============
//Parameter Section
parameter Real W1(unit = "J") = -50 "Work done on the system during constant pressure process";
parameter Real Q1(unit = "J") = -25 "Heat given up during constant pressure process";
parameter Real Q2(unit = "J") = 75 "Heat received during constant volume process";
parameter Real W2(unit = "J") = 0 "Work done during constant volume process";
parameter Real Q3(unit = "J") = 0 "Heat exchange in adiabatic process";

//============
//Variable Section
Real delta_U1(unit = "J") "Change in internal energy during constant pressure process";
Real delta_U2(unit = "J") "Change in internal energy during constant volume process";
Real delta_U3(unit ="J") "Change in internal energy during adiabatic process";
Real W3(unit = "J") "Work done during adiabatic process";

//============
//Equation Section
equation
delta_U1 = Q1-W1;
delta_U2 = Q2-W2;
delta_U3 = -(delta_U1+delta_U2);    //For a cyclic process,the net change in internal energy is zero
W3=-delta_U3;

end Ex2_4;

//===================================================

