//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.5 Page 29
//Title: Heat transfereed along the path
//===================================================

package Ex2_5

model Ex2_5_a

//============
//Parameter Section
parameter Real Q_ACB(unit = "J") = 80 "Total heat supplied to the system";
parameter Real W_ACB(unit = "J") = 30"Work done by the system";
parameter Real W_BA(unit = "J") = -40 "Work done on the system";

//============
//Variable Section
Real delta_U_ACB(unit = "J") "Change in internal energy along ACB";
Real W_ADB(unit = "J") "Work done along ADB"; 
Real Q_ADB(unit = "J") "Heat transferred along ADB";

//============
//Equation Section
equation 
delta_U_ACB = Q_ACB-W_ACB;    //First law of thermodynamics
W_ADB = 3*W_ACB;      //Volume change is zero for process AD and pressure for DB is three times of process AC
Q_ADB = delta_U_ACB+W_ADB;    //delta_U_ACB = delta_U_ADB

end Ex2_5_a;

//============

model Ex2_5_b

extends Ex2_5_a;

//============
//Parameter Section
parameter  Real delta_U_AD(unit = "J") = 40 "Change in internal energy along AD";

//============
//Variable Section
Real Q_AD(unit = "J")"Heat transferred along AD";
Real delta_U_AB(unit = "J") "Change in internal energy along AB";
Real delta_U_DB(unit = "J") "Change in internal energy along DB";
Real W_DB(unit = "J") "Work done along DB";
Real Q_DB(unit = "J") "Heat transferred along DB";

//=============
//Equation Section
equation 
Q_AD = delta_U_AD ;   // W_AD = 0 since it is a constant volume process
delta_U_AB = delta_U_ACB;   //Internal enegy is a state function
delta_U_DB = delta_U_AB-delta_U_AD;  
W_DB = W_ADB;   //W_AD = 0
Q_DB = delta_U_DB+W_DB;

end Ex2_5_b;

//============

model Ex2_5_c

extends Ex2_5_b;

//Variable Section
Real delta_U_BA(unit = "J") "Change in internal energy along BA";
Real Q_BA(unit = "J") "Heat transferred along BA";

//=============
//Equation Section
equation 
delta_U_BA = -delta_U_AB;
Q_BA = delta_U_BA+W_BA;

end Ex2_5_c;

//============

end Ex2_5;
