package Ex2_6
  //Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
  //Chapter 2: First Law of Thermodynamics
  //Example: 2.6 Page 30
  //Title: Volume of the tank and Heat transferred in a tank
  //===================================================

  model Ex2_6_a
    //============
    //Parameter Section
    parameter Real m(unit = "kg") = 10 "Mass of  water";
    parameter Real T1(unit = "K") = 300.15 "Temperature of water";
    parameter Real P1(unit = "kPa") = 101.3 "Pressure of water";
    parameter Real mVl(unit = "m^3/kg") = 0.001003 "Specific volume of sat. water at 300.15 K";
    parameter Real mVv(unit = "m^3/kg") = 38.81 "Specific volume of water vapour at 300.15 K";
    parameter Real mUl(unit = "kJ/kg") = 113.1 "Internal energy of sat. liquid";
    parameter Real mUv(unit = "kJ/kg") = 2412.6 "Internal energy of sat. vapour";
    //============
    //Variable Section
    Real V(unit = "m^3") "Volume of the container";
    //============
    //Equation Section
  equation
    V = 2 * m * mVl;
//Water occupies half the volume of container
  end Ex2_6_a;

  //============

  model Ex2_6_b
    extends Ex2_6_a;
    //============
    //Variable Section
    Real mV(unit = "m^3/kg") "Specific volume at 300.15 K";
    //============
    //Equation Section
  equation
    mV = V / m;
//Pressure should be saturation pressure
  end Ex2_6_b;

  model Ex2_6_c
  
  extends Ex2_6_a;
  
  //============
  //Variable Section
  Real mV(unit = "m^3/kg") "Specific volume of water in container";
  Real x(unit = "-") "Fraction of vapour in the mixture";
  Real mU2(unit = "kJ/kg") "Internal energy in final state";
  Real delta_U(unit = "kJ/kg") "Change in internal energy";
  Real Q(unit = "kJ") "Heat transferred";
  
  //============
  //Equation Section
  equation
  mV = V/m;     
  mVl+ x*(mVv-mVl) = mV;
  mU2 = mUl+x*(mUv-mUl);
  delta_U = mU2-mUl;
  Q = m*delta_U;        //W= 0 Q=delta_U from first law of thermodynamics
  
  /* Answer provided in the book is incorrect for delta_U. Answer given in the book is 0.05 kJ/kg but answer from calculation is 0.06 kJ/kg */
  
  end Ex2_6_c;

  //=============
end Ex2_6;
