//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.13 Page 75
//Title: Amount of heat added or removed
//===================================================

model Ex3_13

//=============
//Parameter Section
parameter Real A(unit = "%") = 100 "Percentage of excess air";
parameter Real CO(unit = "%") = 80 "Percentage of CO burnt";
parameter Real T1(unit = "K") = 373 "Temperature of reactant";
parameter Real T2(unit = "K") = 573 "Temperature of product";
parameter Real T(unit = "K") = 298 "Reference temperature";
parameter Real Cp_a1(unit  ="kJ/kmol K") = 29.22 "Mean molal specific heat of CO between 298 K and 373 K";
parameter Real Cp_a2(unit  ="kJ/kmol K") = 30.61 "Mean molal specific heat of CO between 298 K and 573 K";
parameter Real Cp_b2(unit  ="kJ/kmol K") = 43.77 "Mean molal specific heat of CO2 between 298 K and 573 K";
parameter Real Cp_c1(unit  ="kJ/kmol K") = 29.84 "Mean molal specific heat of O2 between 298 K and 373 K";
parameter Real Cp_c2(unit  ="kJ/kmol K") = 30.99 "Mean molal specific heat of O2 between 298 K and 573 K";
parameter Real Cp_d1(unit  ="kJ/kmol K") = 29.17 "Mean molal specific heat of N2 between 298 K and 373 K";
parameter Real Cp_d2(unit  ="kJ/kmol K") = 29.66 "Mean molal specific heat of N2 between 298 K and 573 K";
parameter Real delta_Ha(unit = "kJ/mol") = -110.524 "Standard heat of formation of CO at 298 K";
parameter Real delta_Hb(unit = "kJ/mol") = -393.514 "Standard heat of formation of CO2 at 298 K";

//============
//Variable Section
Real na_f(unit = "kmol") "Moles of CO fed";
Real nc_t(unit = "kmol") "Theoretical requirement of O2";
Real nc_a(unit = "kmol") "O2 supplied";
Real na(unit = "kmol") "Moles of CO in product stream";
Real nb(unit = "kmol") "Moles of CO2 in product stream";
Real nc(unit = "kmol") "Moles of O2 in product stream";
Real nd(unit = "kmol") "Moles of N2 ";
Real delta_H1(unit = "kJ") "Enthalpy of cooling reactants from 373 K to 298 K";
Real delta_H298(unit = "kJ") "Standard heat of reaction at 298 K";
Real delta_H2(unit = "kJ") "Enthalpy of heating products from 298 K to 573 K";
Real delta_H(unit = "kJ") "Enthalpy change during the reaction";
String Heat;

//============
//Equation Section
equation
//CO+(1/2)O2 ---> CO2
na_f = 1;   //Basis
nc_t = 0.5;   //From stoichiometry
nc_a = nc_t*(1+(A/100));
na = na_f-(CO/100);
nb = CO/100;
nc = (na*nc_t)+(nc_a-nc_t);
nd = na_f*79/21;   //Composition of nitrogen and oxygen in air is 79% and 21%
delta_H1 = ((na_f*Cp_a1)+(nc_a*Cp_c1)+(nd*Cp_d1))*(T-T1);
delta_H298 = (delta_Hb-delta_Ha)*10^3*(CO/100);
delta_H2 = ((na*Cp_a2)+(nb*Cp_b2)+(nc*Cp_c2)+(nd*Cp_d2))*(T2-T);
delta_H = delta_H1+delta_H298+delta_H2;

if delta_H >= 0 then
Heat = "Heat Added";
else
Heat = "Heat Removed";
end if;

Modelica.Utilities.Streams.print(Heat);


end Ex3_13;

//===================================================
