//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.17 Page 78
//Title: Excess air used
//===================================================

model Ex3_17

//============
//Parameter Section
parameter Real T1(unit = "K") = 298 "Initial temperture";
parameter Real T(unit = "K") = 1600 "Flame temperature";
parameter Real Cp_c(unit  ="J/mol K") = 51.66 "Mean molal specific heat of CO2 ";
parameter Real Cp_d(unit  ="J/mol K") = 40.45 "Mean molal specific heat of H2O ";
parameter Real Cp_b(unit  ="J/mol K") = 34.01 "Mean molal specific heat of O2 ";
parameter Real Cp_e(unit  ="J/mol K") = 32.21 "Mean molal specific heat of N2 ";
parameter Real delta_Ho(unit = "J/mol") = -8.028*10^5 "Standard heat of reaction at 298 K";

//============
//Variable Section
Real na_f(unit = "mol") "Moles of CH4 fed";
Real nb_t(unit = "mol") "Theoretical requirement of O2";
Real x(unit = "mol") "Moles of O2 supplied";
Real nc(unit = "mol") "Moles of CO2 in product stream";
Real nd(unit = "mol") "Moles of H2O in product stream";
Real delta_H1(unit = "J") "Enthalpy of reactants at 298 K";
Real delta_H(unit = "J") "Enthalpy change during the reaction";
Real A(unit = "%") "Percent excess of air supplied";

//============
//Equation Section
equation
na_f = 1;   //Basis
nb_t = 2;   //From stoichiometry
nc = 1;
nd = 2;
delta_H1 = 0;   //Reactants are initially at the temperature of reaction
delta_H = 0;    //Adiabatic reaction
delta_H = delta_H1+delta_Ho+(((nc*Cp_c)+(nd*Cp_d)+((x-nb_t)*Cp_b)+((79/21)*x*Cp_e))*(T-T1));
A = (x-nb_t)/(nb_t)*100;

end Ex3_17;
