//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.18 Page 79
//Title: Moles of CO2 per mole of O2 in feed stream
//===================================================

model Ex3_18

//============
//Parameter Section
parameter Real del_H1(unit = "kJ/mol") = 170 "Heat of reaction for rxn 1";
parameter Real del_H2(unit = "kJ/mol") = -220.4 "Heat of reaction for rxn 2";
parameter Real T(unit = "K") = 1298 "Temperature of inlet and exit gas";
parameter Real T1(unit = "K") = 298 "Standard temperature";
parameter Real Cp_C(unit = "kJ/mol K") = 0.02 "Mean molal heat capacity of carbon";
parameter Real Cp_O2(unit = "kJ/mol K") = 0.03 "Mean molal heat capacity of oxygen";
parameter Real Cp_CO(unit = "kJ/mol K") = 0.03 "Mean molal heat capacity of carbon monoxide";
parameter Real Cp_CO2(unit = "kJ/mol K") = 0.05 "Mean molal heat capacity of carbon dioxide";
parameter Real a(unit = "-") = 1 "Stoichiometric coefficient of CO2 in rxn 1";
parameter Real b(unit = "-") = 1 "Stoichiometric coefficient of C in rxn 1";
parameter Real c(unit = "-") = 2 "Stoichiometric coefficient of CO in rxn 1";
parameter Real d(unit = "-") = 1 "Stoichiometric coefficient of O2 in rxn 2";
parameter Real e(unit = "-") = 2 "Stoichiometric coefficient of C in rxn 2";
parameter Real f(unit = "-") = 2 "Stoichiometric coefficient of CO in rxn 2";

//============
//Variable Section
Real x(unit = "mol") "Moles of CO2 per mole of O2";

//=============
//Equation Section
equation
//1. CO2(g)+C(s) ----> 2CO(g)  
//2. O2(g)+2C(s) ----> 2CO(g)
((a*x*Cp_CO2)+(d*Cp_O2)+(((b*x)+e)*Cp_C))*(T1-T)+((del_H1*x)+del_H2)+(((c*x)+f)*Cp_CO)*(T-T1) = 0;
                      // delta_H1+delta_H298+delta_H2 = 0, Adiabatic process

end Ex3_18;

//===================================================
