//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.7 Page 63
//Title: Ideal gas and van der Waals equation
//===================================================

package Ex3_7

model Ex3_7_a

//=============
//Parameter Section
parameter Real n(unit = "mol") = 1 "Mole of oxygen";
parameter Real T(unit = "K") = 300 "Temperature of the gas";
parameter Real P(unit = "bar") = 100 "Pressure of the gas";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real V(unit = "m^3") "Volume of gas by ideal gas equation";

//============
//Equation Section
equation
V = (n*R*T)/(P*10^5);   //Ideal gas equation

end Ex3_7_a;

//=============
model Ex3_7_b

extends Ex3_7_a;

//============
//Parameter Section
parameter Real a(unit = "N m^4/mol^2") = 0.1378 "van der Waals constant";
parameter Real b(unit = "m^3/mol") = 3.18/10^5 "vand der Waals constant";

//============
//Variable Section
Real V1(unit = "m^3/mol") "Volume of gas by van der Waals equation";

//===========
//Equation Section
equation
((P*10^5)+(a/V1^2))*(V1-b)-(R*T) = 0;   //Converting pressure from bar to kPa


end Ex3_7_b;

//===========

end Ex3_7;
