//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.9 Page 66
//Title: Virial and Redlich-Kwong equation
//===================================================

package Ex3_9

model Ex3_9_a

//============
//Parameter Section
parameter Real B(unit = "m^3/mol") = -2.19/10^4 "virial eqn. constant";
parameter Real C(unit = "'m^6/mol^2") = -1.73/10^8 "virial eqn. constant";
parameter Real T(unit = "K") = 500 "Temperature of the methanol vapour";
parameter Real P(unit = "bar") = 10 "Pressure of the methanol vapour";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real Z(unit = "-") "Compressibility factor using virial equation";
Real V(start = 4.157/10^3, unit = "m^3/mol") "Molar volume of the methanol vapour from virial equation"; //Ideal gas volume is given as start value

//============
//Equation Section
equation  
V = (((R*T)/(P*10^5)))*(1+(B/V)+(C/V^2));   //Truncated form of virial equation
Z = (P*10^5*V)/(R*T);

end Ex3_9_a;

//=============

model Ex3_9_b

extends Ex3_9_a;

//=============
//Parameter Section
parameter Real Tc(unit = "K") = 512.6 "Critical temperature";
parameter Real Pc(unit = "bar") = 81 "Critical pressure";


//=============
//Variable Section
Real a(unit = "Nm^4K^0.5/mol^2") "Constant in Redlich-Kwong equation";
Real b(unit = "m^3/mol") "Constant in Redlich-Kwong equation";
Real V1(start = 4.157/10^3, unit = "m^3/mol") "Molar volume of the methanol vapour from Redlich-Kwong equation";
               //Ideal gas volume is given as start value
Real Z1(unit = "-") "Compressibility factor using Redlich-Kwong equation";

//=============
//Equation Section
equation 
a = (0.4278*R^2*Tc^2.5)/(Pc*10^5);    //Converting Pc from bar to Pa
b = (0.0867*R*Tc)/(Pc*10^5);    //Converting Pc from bar to Pa
V1 = ((R*T)/(P*10^5))+b-((a*(V1-b))/(T^0.5*(P*10^5)*V1*(V1+b)));
Z1 = (P*10^5*V1)/(R*T);

end Ex3_9_b;

//=============

end Ex3_9;
