//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.13 Page 107
//Title: Entropy change for chemical reactions
//===================================================

model Ex4_13

//CO+(1/2)O2 = CO2

//============
//Parameter Section
parameter Real P(unit = "bar") = 1 "Pressure of the reaction";
parameter Real T(unit = "K") = 298 "Temperature of the reaction";
parameter Real delta_H(unit = "J/mol") = -2.8318*10^5 "Heat of the reaction";
parameter Real S_CO(unit = "J/mol K") = 198 "Absolute entropy of carbon monoxide";
parameter Real S_O2(unit = "J/mol K") = 205.2 "Absolute entropy of oxygen";
parameter Real S_CO2(unit = "J/mol K") = 213.8 "Absolute entropy of carbon dioxide";

//============
//Variable Section
Real Sp(unit = "J/K") "Entropy of product";
Real Sr(unit = "J/K") "Entropy of reactants";
Real delta_S(unit = "J/K") "Change in entropy";
Real E(unit = "J") "Energy available for useful work";

//============
//Equation Section 
equation
Sp = S_CO2;
Sr = (S_CO+(0.5*S_O2));
delta_S = Sp-Sr;
//Since reaction is highly irreversible, delta_S cannot be calculated as the ratio of heat of reaction to temperature
E = -((delta_H)-(T*delta_S));

end Ex4_13;

//===================================================
