//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.15 Page 113
//Title: Change in entropy of steam
//===================================================

model Ex4_15

//============
//Parameter Section
parameter Real P1(unit = "MPa") = 1.5 "Pressure of superheated steam";
parameter Real T1(unit = "K") = 523 "Temperature of superheated steam";
parameter Real H1(unit = "kJ/kg") = 2923.5 "Enthalpy of superheated steam";
parameter Real S1(unit = "kJ/kg K") = 6.71 "Entropy of superheated steam";
parameter Real T2(unit = "K") = 300 "Temperature of saturated liquid";
parameter Real H2(unit = "kJ/kg") = 845 "Enthalpy of saturated liquid";
parameter Real S2(unit = "kJ/kg K") = 2.32 "Entropy of saturated liquid";

//============
//Variable Section
Real delta_S1(unit = "kJ/kg K") "Change in entropy of system";
Real Q(unit = "kJ/kg") "Heat given out by steam";
Real delta_S2(unit = "kJ/kg K") "Change in entropy of surrounding";
Real delta_S(unit = "kJ/kg K") "Total change in entropy";
String Reversibility;

//============
//Equation Section
equation
delta_S1 = (S2-S1);
Q = -(H2-H1);
delta_S2 = (Q/T2);
delta_S = delta_S1+delta_S2;

if delta_S >0 then
Reversibility = "Irreversible";
elseif delta_S ==0 then
Reversibility = "Reversible";
else
Reversibility = "Not Applicable";
end if;

Modelica.Utilities.Streams.print(Reversibility);

end Ex4_15;

//Unit of delta_S2 and delta_S is incorrect in textbook

//===================================================

