//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.16 Page 113
//Title: Change in entropy of the system
//===================================================

model Ex4_16

//============
//Parameter Section
parameter Real V(unit = "m^3") = 1 "Volume of the compartments";
parameter Real P1(unit = "kPa") = 683.6 "Pressure of sat. steam";
parameter Real P2(unit = "kPa") = 101.3 "Pressure of superheated steam";
//From steam tables, for saturated steam at 683.6 kPa 
parameter Real H1(unit = "kJ/kg") = 2761 "Enthalpy of sat. steam";
parameter Real S1(unit = "kJ/kg K") = 6.7133 "Entropy of sat. steam";
parameter Real v1(unit = "m^3/kg") = 0.2789 "Specific volume of sat. steam";
parameter Real mU1(unit = "kJ/kg") = 2570.4 "Specific internal energy of sat. steam";
//from steam tables, for superheated steam at 101.3 kPa and 437.2 K
parameter Real H2(unit = "kJ/kg") = 2804 "Enthalpy of superheated steam";
parameter Real S2(unit = "kJ/kg K") = 7.6712 "Entropy of superheated steam";
parameter Real v2(unit = "m^3/kg") = 1.9762 "Specific volume of superheated steam";
parameter Real mU2(unit = "kJ/kg") = 2603.3 "Specific internal energy of superheated steam";
//By interpolation
parameter Real S(unit = "kJ/kg K") = 6.9992 "Specific entropy of the system";

//=============
//Variable Section
Real m1(unit = "kg") "Mass of sat. steam";
Real m2(unit = "kg") "Mass of superheated steam";
Real m(unit = "kg") "Mass of the system";
Real v(unit = "m^3/kg") "Specific volume of the system";
Real U1(unit = "kJ")  "Internal energy of sat. steam";
Real U2(unit = "kJ")  "Internal energy of superheated steam";
Real U(unit = "kJ/kg")  "Specific internal energy of the system";
Real Si(unit = "kJ/K") "Initial entropy of the system";
Real Sf(unit = "kJ/K") "Final entropy of the system";
Real delta_S(unit = "kJ/K") "Change in entropy";
String Reversibility;

//============
//Equation Section
equation
m1 = V/v1;
m2 = V/v2;
m = m1+m2;
v = (2*V)/m;
U1 = mU1*m1;
U2 = mU2*m2;
U = (U1+U2)/m;
Si = (S1*m1)+(S2*m2);
Sf =  S*m;
delta_S = Sf-Si;


if delta_S >0 then
Reversibility = "Irreversible";
elseif delta_S ==0 then
Reversibility = "Reversible";
else
Reversibility = "Not Applicable";
end if;

Modelica.Utilities.Streams.print(Reversibility);

end Ex4_16;

//===================================================
