//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.20 Page 117
//Title: Change in entropy of the system
//===================================================

package Ex4_20

model Ex4_20_a

//============
//Parameter Section
parameter Real Thi(unit = "K") = 425 "Inlet temperature of oil";
parameter Real Tho(unit = "K") = 340 "Outlet temperature of oil";
parameter Real mh(unit = "kg/h") = 5000 "Mass flow rate of oil";
parameter Real Tci(unit = "K") = 295 "Inlet temperature of cold water";
parameter Real mc(unit = "kg/h") = 10000 "Mass flow rate of water";
parameter Real Cph(unit = "kJ/kg K") = 2.5 "Specific heat of oil";
parameter Real Cpc(unit = "kJ/kg K") = 4.2 "Specific heat of water";

//============
//Variable Section
Real Tco(unit = "K") "Outlet temperature of cold water";
Real delta_S_h(unit = "kJ/K") "Change in entropy of oil";
Real delta_S_c(unit = "kJ/K") "Change in entropy of water";
Real delta_S(unit = "kJ/K") "Total change in entropy";

//===========
//Equation Section
equation
mh*Cph*(Thi-Tho) = mc*Cpc*(Tco-Tci);
delta_S_h = mh*Cph*log(Tho/Thi);
delta_S_c = mc*Cpc*log(Tco/Tci);
delta_S = delta_S_h+delta_S_c;

end Ex4_20_a;

model Ex4_20_b

extends Ex4_20_a;

//============
//Parameter Section
parameter Real To(unit = "K") = 295 "Temperature";

//============
//Variable Section
Real Q(unit = "kJ/h") "Heat from oil";
Real Q2(unit = "kJ/h") "Heat rejected to the surrounding";
Real W(unit = "kJ") "Work output of the engine";

//===========
//Equation Section
equation
Q = mh*Cph*(Thi-Tho);
Q2 = -(To*delta_S_h);
W = Q-Q2;

end Ex4_20_b;

end Ex4_20;
