//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.8 Page 105
//Title: Change in entropy
//===================================================

model Ex4_8

//==============
//Parameter Section
parameter Real n(unit = "kmol") = 1 "Moles of ideal gas";
parameter Real T(unit = "K") = 300 "Temperature of the gas";
parameter Real P1(unit = "bar") = 10 "Initial pressure of the gas";
parameter Real P2(unit = "bar") = 1 "Final pressure of the gas";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//==============
//Variable Section
Real delta_S(unit = "kJ/kmol K") "Change in entropy";

//=============
//Equation Section
equation
delta_S = (R*log(P1/P2));   //Temperature remains unchanged during throttling

end Ex4_8;

//===================================================
