//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.14 Page 154
//Title: Power requirement 
//===================================================

model Ex5_14

//============
//Parameter Section
parameter Real T2(unit = "K") = 261 "Temperature of solution";
parameter Real Q(unit = "kJ/min") = 1000 "Heat removed";
parameter Real T1(unit = "K") = 288 "Surrounding temperature";

//===========
//Variable Section
Real W(unit = "kJ/min") "Work requirement";
Real P(unit = "hp") "Power requirement";

//==========
//Equation Section
equation
W = Q*((T1-T2)/T2);     //Using Eqn. 5.57 Reg pg no. 153
P = (W*1000)/(746*60);    //Converting kJ/min to hp

end Ex5_14;

//===================================================
