//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.15 Page 154
//Title: Refrigeration cycle
//===================================================

package Ex5_15
  
  model Ex5_15_a
    //===========
    //Parameter Section
    parameter Real T1(unit = "K") = 290 "Condenser temperature";
    parameter Real W(unit = "kW") = 1 "Work requirement";
    parameter Real Q2(unit = "W") = 3516.67 "1 Ton of Refrigeration";
    //==========
    //Variable Section
    Real COP(unit = "-") "Coefficient of performance";
    //==========
    //Equation Section
  equation
    COP = Q2 / (W * 10 ^ 3);
  end Ex5_15_a;

  //==========

  model Ex5_15_b
  
  extends Ex5_15_a;
  
  //===========
  //Variable Section
  Real Q1(unit = "kW") "Heat rejected to the condenser";
  
  equation
  Q1 = (Q2+(W*10^3))/10^3;
  
  end Ex5_15_b;

  //==========

  model Ex5_15_c
  
    extends Ex5_15_b;
    
    //===========
    //Variable Section
        Real T2(unit = "K") "Lowest temperature that can be maintained";
        
    //============
    //Equation Section
  equation
    T2 = T1*((Q2/10^3)/Q1);
    
  end Ex5_15_c;

  //==========
end Ex5_15;
