//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.16 Page 157
//Title: Vapour compression refrigeration
//===================================================

package Ex5_16

model Ex5_16_a

//===========
//Parameter Section
parameter Real T2(unit = "K") = 266 "Low temperature";
parameter Real T1(unit = "K") = 300 "High temperature";
parameter Real HA(unit = "kJ/kg") = 656 "Enthalpy of sat. vapour at 266 K";
parameter Real HB(unit = "kJ/kg") = 724 "Enthalpy of superheated vapour";
parameter Real HC(unit = "kJ/kg") = 144 "Enthalpy of sat. liquid at 300 K";

//==========
//Variable Section
Real HD(unit ="kJ/kg") "Enthalpy after expansion";
Real COP(unit = "-") "Coefficient of performance";

//==========
//Equation Section
equation
HD = HC;
COP = (HA-HD)/(HB-HA);    //Using Eqn. 5.61 pg no. 156

end Ex5_16_a;

//==========

model Ex5_16_b

//===========
//Parameter Section
parameter Real T(unit = "K") = 5 "Approach temperature";
parameter Real T2(unit = "K") = 261 "Low temperature";
parameter Real T1(unit = "K") = 305 "High temperature";
parameter Real eta(unit = "-") = 0.75 "Efficiency of compressor";
parameter Real HA(unit = "kJ/kg") = 652 "Enthalpy of sat. vapour at 261 K";
parameter Real HB(unit = "kJ/kg") = 758 "Enthalpy of superheated vapour";
parameter Real HC(unit = "kJ/kg") = 159 "Enthalpy of sat. liquid at 305 K";

//==========
//Variable Section
Real HD(unit ="kJ/kg") "Enthalpy after expansion";
Real COP(unit = "-") "Coefficient of performance";

//==========
//Equation Section
equation
HD = HC;
COP = ((HA-HD)/(HB-HA))*eta;    //Using Eqn. 5.61 pg no. 156

end Ex5_16_b;

//============

model Ex5_16_c

extends Ex5_16_a;

//==========
//Variable Section
Real COP_i(unit = "-") "Coefficient of performance of ideal refrigerator";

//==========
//Equation Section
equation
COP_i = T2/(T1-T2);

end Ex5_16_c;

//==========

end Ex5_16;
