//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.25 Page 175
//Title: Reheat cycle
//===================================================

package Ex5_25

model Ex5_25_a

//===========
//Parameter Section
parameter Real T3(unit = "K") = 673 "Temperature of steam entering the high-pressure turbine";
parameter Real P2(unit = "kPa") = 7600 "Pressure of steam entering the high-pressure turbine";
parameter Real P(unit = "MW") = 1 "Power of steam power plant";
parameter Real P4(unit = "kPa") = 1400 "Pressure of steam after expansion";
parameter Real T5(unit = "K") = 658 "Temperature of steam entring low-pressure turbine";
parameter Real P1(unit = "kPa") = 5 "Pressure of steam after expansion in low-pressure turbine";
parameter Real V(unit = "m^3/kg") = 1.005/10^3 "Specific volume of sat. liquid at 5 kPa";
parameter Real Hl_6(unit = "kJ/kg") = 138 "Enthalpy of sat. liquid at 5 kPa";
parameter Real Sl_6(unit = "kJ/kg K") = 0.4764 "Entropy of sat. liquid at 5 kPa";
parameter Real Hv_6(unit = "kJ/kg") = 2562 "Enthalpy of sat. vapour at 5 kPa";
parameter Real Sv_6(unit = "kJ/kg K") = 8.3951 "Entropy of sat. vapour at 5 kPa";
parameter Real Hl_4(unit = "kJ/kg") = 830 "Enthalpy of sat. liquid at 1400 kPa";
parameter Real Sl_4(unit = "kJ/kg K") = 2.2842 "Entropy of sat. liquid at 1400 kPa";
parameter Real Hv_4(unit = "kJ/kg") = 2790 "Enthalpy of sat. vapour at 1400 kPa";
parameter Real Sv_4(unit = "kJ/kg K") = 6.4693 "Entropy of sat. vapour at 1400 kPa";
parameter Real  H5(unit = "kJ/kg") = 3226  "'Enthlpy of superheated steam at 1400 kPa and 658 K";
parameter Real  S5(unit = "kJ/kg K") = 7.2558  "'Entropy of superheated steam at 1400 kPa and 658 K";
parameter Real  H3(unit = "kJ/kg") = 3150  "'Enthlpy of superheated steam at 7600 kPa and 658 K";
parameter Real  S3(unit = "kJ/kg K") = 6.4022  "'Entropy of superheated steam at 7600 kPa and 658 K";


//===========
//Variable Section
Real S4(unit = "kJ/kg K") "Entropy of steam leaving the high-pressure turbine";
Real x4(unit = "-") "Fraction of steam leaving high-pressure turbine in vapour state";
Real H4(unit = "kJ/kg") "Enthalpy of steam leaving the high-pressure turbine";
Real W4(unit = "kJ/kg")  "Work output of the high-pressure turbine";
Real S6(unit = "kJ/kg K") "Entropy of steam leaving the low-pressure turbine";
Real x6(unit = "-") "Fraction of steam leaving low-pressure turbine in vapour state";
Real H6(unit = "kJ/kg") "Enthalpy of steam leaving the low-pressure turbine";
Real W6(unit = "kJ/kg")  "Work output of the low-pressure turbine";

//==========
//Equation Section
equation 
S4 = S3;    //Expansion process is isentropic
S4 = Sl_4+(x4*(Sv_4-Sl_4));
H4 = Hl_4+(x4*(Hv_4-Hl_4));
W4 = H3-H4;
S6 = S5;    //Expansion process is isentropic
S6 = Sl_6+(x6*(Sv_6-Sl_6));
H6 = Hl_6+(x6*(Hv_6-Hl_6));
W6 = H5-H6;

end Ex5_25_a;

//===========

model Ex5_25_b

extends Ex5_25_a;

//==========
//Variable Section
Real eta(unit = "%") "Efficiency of the cycle";
Real Ws(unit = "kJ/kg") "Work input to the feed water pump";
Real H1(unit = "kJ/kg") "Enthalpy of water entering the pump";
Real H2(unit = "kJ/kg") "Enthalpy of water leaving the pump";

//==========
//Equation Section
equation
Ws = V*(P2-P1);
H1 = Hl_6;
H2 = H1+Ws;
eta = ((H3-H2)+(H5-H4)-(H6-H1))/((H3-H2)+(H5-H4))*100;    //Efficiency = net work/heat input

end Ex5_25_b;

//===========

model Ex5_25_c

extends Ex5_25_b;

//==========
//Variable Section 
Real Wnet(unit = "kJ/kg") "Net work output";
Real m(unit = "kg/h")  "Rate of steam circulation";

//==========
//Equation Section
equation
Wnet = (H3-H2)+(H5-H4)-(H6-H1);
m = (P*10^3*3600)/Wnet;

end Ex5_25_c;

end Ex5_25;

//===================================================
